#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

int main() {
    int N;
    cin >> N;
    
    vector<int> A(N), B(N);
    for (int i = 0; i < N; i++) {
        cin >> A[i];
    }
    for (int i = 0; i < N; i++) {
        cin >> B[i];
    }

    int maxValue = 0;
    
    // Brute force approach O(n^2)
    for (int L = 0; L < N; L++) {
        int xorValue = 0; // Initial xor value for the range
        int andValue = -1; // Initial and value for the range (AND identity is -1)
        
        for (int R = L; R < N; R++) {
            xorValue ^= A[R];  // XOR of elements from A[L] to A[R]
            andValue &= B[R];  // AND of elements from B[L] to B[R]
            
            // Calculate the value of the current subarray
            maxValue = max(maxValue, xorValue * andValue);
        }       
    }

    cout << maxValue << endl;
    return 0;
}